/**
 * ${jpp:disclaimer}
 *
 * ${jpp:copyright}
**/
package pdfc;

import com.inet.pdfc.PDFComparer;
import com.inet.pdfc.config.DefaultProfile;
import com.inet.pdfc.config.XMLProfile;
import com.inet.pdfc.error.PdfcException;
import com.inet.pdfc.generator.message.InfoData;
import com.inet.pdfc.generator.model.DiffGroup;
import com.inet.pdfc.generator.model.Modification;
import com.inet.pdfc.results.ResultModel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

import java.io.File;
import java.util.InvalidPropertiesFormatException;
import java.net.URISyntaxException;
import java.util.List;

import util.SampleUtil;

/**
 * A sample for writing JUnit test cases using PDFC
 */
public class CompareTest {

    private PDFComparer pdfComparer;

    @Before
    public void before() {
        SampleUtil.init();
        pdfComparer = new PDFComparer();
    }

    @Test
    public void testDifferences() throws PdfcException, InvalidPropertiesFormatException, URISyntaxException {
        File example1 = new File( getClass().getResource( "/Example1.pdf" ).toURI() );
        File example2 = new File( getClass().getResource( "/Example2.pdf" ).toURI() );
        File profil = new File( getClass().getResource( "/Continuous_document_profil.xml" ).toURI() );

        ResultModel result = new PDFComparer().setProfile( new XMLProfile(profil) ).compare( example1, example2 );
        InfoData comparisonParameters = result.getComparisonParameters();

        Assert.assertEquals( 12, result.getDifferencesCount( false ) );
        Assert.assertEquals( 12, result.getDifferencesCount( true ) );

        Assert.assertEquals( 3, comparisonParameters.getFirstPageCount() );
        Assert.assertEquals( 3, comparisonParameters.getSecondPageCount() );
    }
}
